﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace AZVIC.Ei8htPOS.POSRetail.Converters
{
    public class ProductDetailConverter : BaseConverter, IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            Guid val = Guid.Parse(value.ToString());
            if (val != null)
            {

                switch (parameter.ToString())
                {
                    case UIConstants.COLOR:
                       var Color = AppSession.ColorList.Where(color => color.UniqueID == val).Select(a => a).ToList<ProductColor>().Count>0?AppSession.ColorList.Where(color => color.UniqueID == val).Select(a => a).ToList<ProductColor>().Single():null;
                        var ColorDetail = "Color : " +(( Color!=null)? Color.ColorName: " - ");
                        return ColorDetail;
                    case UIConstants.SIZE:
                        var Size = AppSession.MeasurementList.Where(size => size.UniqueID == val).Select(a => a).ToList<ProductMeasurement>().Count>0?AppSession.MeasurementList.Where(size => size.UniqueID == val).Select(a => a).ToList<ProductMeasurement>().Single():null;
                        var SizeDetail = "Size : " + ((Size!=null) ? Size.MeasurementName: " - ");
                        return SizeDetail;
                    case UIConstants.COLORVISIBILITY:
                        var vColor = AppSession.ColorList.Where(color => color.UniqueID == val).Select(a => a).ToList<ProductColor>().Count > 0 ? AppSession.ColorList.Where(color => color.UniqueID == val).Select(a => a).ToList<ProductColor>().Single() : null;
                        return vColor == null ? Visibility.Collapsed : Visibility.Visible;
                    case UIConstants.SIZEVISIBILITY:
                        var vSize = AppSession.MeasurementList.Where(size => size.UniqueID == val).Select(a => a).ToList<ProductMeasurement>().Count > 0 ? AppSession.MeasurementList.Where(size => size.UniqueID == val).Select(a => a).ToList<ProductMeasurement>().Single() : null;
                        return vSize == null ? Visibility.Collapsed : Visibility.Visible;
                    default: return string.Empty;
                }
            }
            return string.Empty;
        }


        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}